// Options.cpp : implementation file
//

#include "stdafx.h"
#include "GrabIt.h"
#include "Options.h"
#include "Mouse.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// COptions dialog


COptions::COptions(CWnd* pParent /*=NULL*/)
	: CDialog(COptions::IDD, pParent)
{
	//{{AFX_DATA_INIT(COptions)
	m_Ears = FALSE;
	m_PlayerDrops = FALSE;
	m_ShowHelp = FALSE;
	m_GfxLite = FALSE;
	m_Passive = FALSE;
	m_Penalty = FALSE;
	//}}AFX_DATA_INIT
}


void COptions::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(COptions)
	DDX_Control(pDX, IDC_SLIDELAG, m_SlideLag);
	DDX_Control(pDX, IDC_LISTCOLORS, m_ListColors);
	DDX_Check(pDX, IDC_CHECKEARS, m_Ears);
	DDX_Check(pDX, IDC_CHECKPDROPS, m_PlayerDrops);
	DDX_Check(pDX, IDC_CHECKSTARTUP, m_ShowHelp);
	DDX_Check(pDX, IDC_CHECKGFX, m_GfxLite);
	DDX_Check(pDX, IDC_CHECKPASSIVE, m_Passive);
	DDX_Check(pDX, IDC_CHECKPENALTY, m_Penalty);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(COptions, CDialog)
	//{{AFX_MSG_MAP(COptions)
	ON_BN_CLICKED(IDC_BTTNNOT, OnBttnNot)
	ON_BN_CLICKED(IDC_BTTNLAG, OnBttnLag)
	ON_BN_CLICKED(IDC_BTTNSAMPLE, OnBttnSample)
	ON_BN_CLICKED(IDC_BTTNP1, OnBttnP1)
	ON_BN_CLICKED(IDC_BTTNP2, OnBttnP2)
	ON_BN_CLICKED(IDC_BTTNP3, OnBttnP3)
	ON_BN_CLICKED(IDC_BTTNP4, OnBttnP4)
	ON_BN_CLICKED(IDC_BTTNP5, OnBttnP5)
	ON_WM_HSCROLL()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// COptions message handlers

void COptions::OnOK() 
{
	// TODO: Add extra validation here
	
	UpdateData( TRUE) ;

	CDialog::OnOK();
}

CString GetColorName(int iColor)
{
	switch (iColor) {
	case 0:  return "DISABLED" ;
	case 1:  return "Red" ;
	case 2:  return "Green" ;
	case 3:  return "Blue" ;
	case 4:  return "Gold" ;
	case 5:  return "Gray" ;
	case 6:  return "Black" ;
	case 7:  return "Darker Yellow" ;
	case 8:  return "Orange" ;
	case 9:  return "Yellow" ;
	case 10: return "White" ;
	case 11: return "Purple" ;
	case 12: return "Dark Green" ;
	}
	return "White" ;
}

BOOL COptions::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here

	m_ListColors.ResetContent() ;
	m_ListColors.SetItemData( m_ListColors.AddString("DISABLED"), 0 ) ;
	m_ListColors.SetItemData( m_ListColors.AddString("Red"), 1 ) ;
	m_ListColors.SetItemData( m_ListColors.AddString("Green"), 2 ) ;
	m_ListColors.SetItemData( m_ListColors.AddString("Blue"), 3 ) ;
	m_ListColors.SetItemData( m_ListColors.AddString("Gold"), 4 ) ;
	m_ListColors.SetItemData( m_ListColors.AddString("Gray"), 5 ) ;
	m_ListColors.SetItemData( m_ListColors.AddString("Black"), 6 ) ;
	m_ListColors.SetItemData( m_ListColors.AddString("Darker Yellow"), 7 ) ;
	m_ListColors.SetItemData( m_ListColors.AddString("Orange"), 8 ) ;
	m_ListColors.SetItemData( m_ListColors.AddString("Yellow"), 9 ) ;
	m_ListColors.SetItemData( m_ListColors.AddString("White"), 10 ) ;
	m_ListColors.SetItemData( m_ListColors.AddString("Purple"), 11 ) ;
	m_ListColors.SetItemData( m_ListColors.AddString("Dark Green"), 12 ) ;
	m_ListColors.SelectString(-1, GetColorName(m_PriorityColor[0])) ;


	SetDlgItemText( IDC_EDITNOT,  GetColorName(m_ColorNot)) ;
	SetDlgItemText( IDC_EDITLAG,  GetColorName(m_ColorLag)) ;
	SetDlgItemText( IDC_PRIORITY1,  GetColorName(m_PriorityColor[0])) ;
	SetDlgItemText( IDC_PRIORITY2,  GetColorName(m_PriorityColor[1])) ;
	SetDlgItemText( IDC_PRIORITY3,  GetColorName(m_PriorityColor[2])) ;
	SetDlgItemText( IDC_PRIORITY4,  GetColorName(m_PriorityColor[3])) ;
	SetDlgItemText( IDC_PRIORITY5,  GetColorName(m_PriorityColor[4])) ;

	SetDlgItemText( IDC_HOTKEY1, "G") ;

	m_SlideLag.SetRange(0, 20);
	m_SlideLag.SetTicFreq(10);
	m_SlideLag.SetPos(m_LagPerYard);
	UpdateData(FALSE) ;
	SetDlgItemInt( IDC_LAG, m_LagPerYard*10) ;

	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}


void COptions::OnBttnNot() 
{
	// TODO: Add your control notification handler code here
	
	m_ColorNot = m_ListColors.GetItemData( m_ListColors.GetCurSel()) ;
	SetDlgItemText( IDC_EDITNOT, GetColorName( m_ColorNot)) ;
}

void COptions::OnBttnLag() 
{
	// TODO: Add your control notification handler code here
	
	m_ColorLag = m_ListColors.GetItemData( m_ListColors.GetCurSel()) ;
	SetDlgItemText( IDC_EDITLAG, GetColorName( m_ColorLag)) ;
}

void COptions::OnBttnSample() 
{
	// TODO: Add your control notification handler code here
	
	wchar_t szText[80] = L"\xff" L"c1Red " L"\xff" L"c2Green " L"\xff" L"c3Blue " L"\xff" L"c4Gold " L"\xff" L"c5Gray " L"\xff" L"c6Black " L"\xff" L"c7Darker Yellow " ;
	SendTextToD2(szText);
	wchar_t szText2[80] = 	L"\xff" L"c8Orange " L"\xff" L"c9Yellow " L"\xff" L"c0White " L"\xff" L"c;Purlple " L"\xff" L"c:Dark Green" ;
	SendTextToD2(szText2);
}

void COptions::OnBttnP1() 
{
	// TODO: Add your control notification handler code here
	
	m_PriorityColor[0] = m_ListColors.GetItemData( m_ListColors.GetCurSel()) ;
	SetDlgItemText( IDC_PRIORITY1, GetColorName( m_PriorityColor[0])) ;
}

void COptions::OnBttnP2() 
{
	// TODO: Add your control notification handler code here
	
	m_PriorityColor[1] = m_ListColors.GetItemData( m_ListColors.GetCurSel()) ;
	SetDlgItemText( IDC_PRIORITY2, GetColorName( m_PriorityColor[1])) ;
}

void COptions::OnBttnP3() 
{
	// TODO: Add your control notification handler code here
	
	m_PriorityColor[2] = m_ListColors.GetItemData( m_ListColors.GetCurSel()) ;
	SetDlgItemText( IDC_PRIORITY3, GetColorName( m_PriorityColor[2])) ;
}

void COptions::OnBttnP4() 
{
	// TODO: Add your control notification handler code here
	
	m_PriorityColor[3] = m_ListColors.GetItemData( m_ListColors.GetCurSel()) ;
	SetDlgItemText( IDC_PRIORITY4, GetColorName( m_PriorityColor[3])) ;
}

void COptions::OnBttnP5() 
{
	// TODO: Add your control notification handler code here
	
	m_PriorityColor[4] = m_ListColors.GetItemData( m_ListColors.GetCurSel()) ;
	SetDlgItemText( IDC_PRIORITY5, GetColorName( m_PriorityColor[4])) ;
}

void COptions::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	// TODO: Add your message handler code here and/or call default

	m_LagPerYard = m_SlideLag.GetPos() ;
	SetDlgItemInt( IDC_LAG, m_LagPerYard*10) ;
	
	CDialog::OnHScroll(nSBCode, nPos, pScrollBar);
}
